<?php
/**
 * Project: Minerva KB
 * Copyright: 2015-2021 @KonstruktStudio
 */
?>
<html>
    <head>
        <title><?php the_title( '', '' ); ?></title>
        <link rel="stylesheet" href="<?php echo esc_attr(MINERVA_KB_PLUGIN_URL . 'assets/css/dist/minerva-kb.css'); ?>">
        <link rel="stylesheet" href="<?php echo esc_attr(MINERVA_KB_PLUGIN_URL . 'assets/css/vendor/font-awesome.css'); ?>">
        <link rel="stylesheet" href="<?php echo esc_attr(MINERVA_KB_PLUGIN_URL . 'assets/css/dist/print.css'); ?>">
        <meta name="robots" content="noindex">

        <?php do_action('minerva_single_print_head'); ?>
    </head>
<body>

<div class="mkb-print-tooltip"><?php echo MKB_Options::option('print_button_tip_text'); ?></div>

<?php

do_action('minerva_single_print_styles');

do_action('minerva_single_print_root_before');

?><div class="mkb-single-print-container"><?php

		?><div class="mkb-single-print-article"><?php

			while (have_posts()) : the_post(); // main loop

				?><div id="mkb-article-<?php the_ID(); ?>"><?php

					do_action('minerva_single_print_title_before');

					?><div class="mkb-page-header"><?php

						do_action('minerva_single_print_title_inside_before');

						if (MKB_Options::option('show_article_title')):
							the_title( '<h1 class="mkb-page-title">', '</h1>' );
						endif;

						do_action('minerva_single_print_title_inside_after');

					?></div><!-- .mkb-entry-header --><?php

					do_action('minerva_single_print_title_after');

					?><div class="mkb-single-content"><?php

						do_action('minerva_single_print_content_inside_before');

						?><div class="mkb-single-content__featured"><?php

							do_action('minerva_single_print_featured_before');

							the_post_thumbnail();

							do_action('minerva_single_print_featured_after');

						?></div><?php

						?><div class="mkb-single-content__text"><?php

							do_action('minerva_single_print_text_before');

                            ?><div class="mkb-article-text mkb-clearfix"><?php

                                global $minerva_kb;

                                if ($minerva_kb->restrict->check_access()):
                                    the_content();
                                else:
                                    echo $minerva_kb->restrict->get_message();
                                endif;

                            ?></div><?php

							do_action('minerva_single_print_text_after');

						?></div><?php

						do_action('minerva_single_print_content_inside_after');

					?></div><!-- .mkb-single-content --><?php

					do_action('minerva_single_print_content_after');

					?></div><!-- #mkb-article-## --><?php

			endwhile;

			?></div><!--.mkb-content-main--><?php

		?></div><!--.mkb-container--><?php

do_action('minerva_single_print_root_after');

?>
</body>
</html>
